"""Tables."""
from mojo import Mojo

from bigym.const import ASSETS_PATH
from bigym.envs.props.prop import Prop

TABLE_PATH = ASSETS_PATH / "props/table/table.xml"


class Table(Prop):
    """Default Table."""

    def __init__(self, mojo: Mojo):
        """Init."""
        super().__init__(mojo, TABLE_PATH, cache_colliders=True)


SMALL_TABLE_PATH = ASSETS_PATH / "props/table_dishwasher/table_dishwasher.xml"


class SmallTable(Prop):
    """Shorter version of the default table."""

    def __init__(self, mojo: Mojo):
        """Init."""
        super().__init__(mojo, SMALL_TABLE_PATH, cache_colliders=True)
